; tablet_import.lsp
; Copyright (C) 1998 Visio Corporation.  All Rights Reserved.

; By Ronald Prepchuk

(defun C:TABLET_IMPORT (/ DCL_ID MENU_LIST MENU_FILE *ERROR* ERROR_ST)
  (defun *ERROR* (STR)
    (princ ERROR_ST)
    (princ STR)
    (princ "\nAvailable commands are: TABLET_IMPORT or TABI, CLEARTAB")
    (princ)
  )
  (setq ERROR_ST "\nError in C:TABLET_IMPORT: ")
  (cond
    ((not tablet_getgriditem) ;not IntelliCAD 98d
     (alert "You are not using IntelliCAD 98d.  This program\nwill only work with release 98d or later.")
     (exit)
    )
    ((and tablet_getgriditem (= (type (tablet_getgriditem 1 1)) 'INT));IntelliCAD 98d but digitizer not configured properly
     (alert "Your digitizer tablet has not been properly configured.\nPlease refer to the documentation for proper setup procedures.")
     (exit)
    )
    ((and tablet_getgriditem (= (type (tablet_getgriditem 1 1)) 'STR));IntelliCAD 98d and digitizer configured properly
     (if (= (setq DCL_ID (load_dialog "tablet.dcl")) -1)
       (progn (setq ERROR_ST "\ntablet.dcl Not Found!") (exit))
       (progn
         (new_dialog "tablet_import" DCL_ID)
         (setq MENU_LIST (READ_INI))
         (mapcar '(lambda (KEY)
		(action_tile KEY "(TAB_IMP_CALLBK $KEY $REASON)")
	      )
	     '("filename_e"    "filename_b"    "Tablet1_ul"
	       "Tablet2_ul"    "Tablet3_ul"    "Tablet4_ul"
	       "Screen_ul"     "Tablet1_lr"    "Tablet2_lr"
	       "Tablet3_lr"    "Tablet4_lr"    "Screen_lr"
	       "Import1"       "Import2"       "Import3"
	       "Import4"       "ImportS"       "accept"
	       "cancel"	       "help"
	      )
         )
         (show_val)
         (show_layout)
         (if MENU_FILE
           (set_tile "filename_e" MENU_FILE)
         )
         (mode_tile "accept" 2) ;set focus to tile
         (if (= (start_dialog) 1)
           (import_menu MENU_FILE MENU_LIST)
         )
         (unload_dialog DCL_ID)
         (setq DCL_ID nil)
        )
      )
    )
  )
  (princ)
)




(defun TAB_IMP_CALLBK ($KEY $REASON / STR)
  (setq ERROR_ST "\Error in TAB_IMP_CALLBK: ")
  (set_tile "error" "")
  (cond
    ((= $KEY "help")
     (alert "1. Start by selecting a menu file to import.  Select the 'Browse' button \nor type the name and location in the 'Filename:' edit box.  The menu \nfile should be an AutoCAD style menu containing TABLET and/or BUTTON \nmenu areas.  The number of cells in each menu area will display in the \ncolumn marked 'Cells'.  After selecting a file two new files will be \ncreated: a log file (.mlg) that contains error messages and an import \nfile (.mni) which contains just the tablet and button areas in the \nformat they will be used in IntelliCAD.\n\n2. For each Tablet menu area enter the 'Upper Left' and 'Lower Right' \ncorners in the format <Row>:<Column>.  For example, the upper left of \n'Tablet 1' is usually A:1.\n\n3. If there are tablet menus you don't want to import you may toggle \nthem on and off.  If you are importing a regular AutoCAD tablet menu\nyou will want to toggle off Tablet 3 since it contains duplicates.")
     )    
    ((= (substr $KEY 1 6) "Import");can't select Screen import toggle
      (setq MENU (assoc (strcat "TABLET" (substr $KEY 7 1)) MENU_LIST))
      ;toggle the last item in MENU between T and nil
      (setq MENU_LIST
	     (subst (subst (if (= (get_tile $KEY) "0") nil T) (last MENU) MENU) MENU MENU_LIST)
	    )
      (show_val)
      )
    ((and (member (substr $KEY 1 6) '("Tablet" "Screen")) (/= (get_tile $KEY) ""))
      (set_tile $KEY (strcase (get_tile $KEY)))
      (setq MENU_CORNER (parse $KEY "_"));returns area and corner
      (setq VAL (parse (get_tile $KEY) ":"))
      (setq MENU (assoc (strcase (car MENU_CORNER)) MENU_LIST))
      (if
	(and
	  (= (length VAL) 2);both row and column exist
	  (check_cell VAL);check for within range
	  )
	(progn
	  (setq MENU	;replace current value in MENU
		 (append
		   (list (car MENU) (cadr MENU));Menu area and # cells
		   (if (= (cadr MENU_CORNER) "ul")
		     (append VAL (list (nth 4 MENU) (nth 5 MENU) (nth 6 MENU)))
		     (append (list (nth 2 MENU) (nth 3 MENU)) VAL (list (nth 6 MENU)))
		     )
		   )
		)
	  (setq MENU_LIST (subst MENU (assoc (strcase (car MENU_CORNER)) MENU_LIST) MENU_LIST))
	  (if (/= "" (nth (if (= (cadr MENU_CORNER) "ul") 4 2) MENU));Other corner not empty
	    (progn
	      (set_tile (strcat "Import" (substr (car MENU_CORNER) 7)) "1");turn Import toggle On
	      (show_layout)
	      (if (check_area MENU)
		(set_tile "error" "Areas overlap.  Please change")
		)
	      )
	    )
	  )
	(progn
          (show_val)	  
	  (mode_tile $KEY 2)
 	  (set_tile "error" "Out of range . . Resetting")	  
	  )
	)
      )
    ((= (substr $key 1 8) "filename")
      (setq FILENAME
        (if (= $KEY "filename_e")
          (if (setq STR (findfile (get_tile "filename_e")))
	    STR
	    (if (= (get_tile "filename_e") "") nil (progn (set_tile "error" (strcat "File '" (get_tile "filename_e") "' not found!")) nil))
	    )
          (if (setq STR (getfiled "Select a menu file" (if MENU_FILE MENU_FILE (if (findfile "acad.mnu") (findfile "acad.mnu") "")) "mnu" 0))
	    (progn
              (set_tile "filename_e" (setq MENU_FILE STR))
  	      (setq MENU_FILE (car (parse MENU_FILE ".")));strip extension
	      (read_menu MENU_FILE)
	      (show_val)
	      (show_layout)
	      )
	    )
	  )
        )
      )
    ((= $KEY "accept")
      (save_ini)
      (done_dialog 1)
      )
    )
  )
    

(defun CHECK_CELL (VAL)
  (setq ERROR_ST "\Error in CHECK_CELL: ")  
  (and (<= "A" (car VAL) "Z")
       (= (strlen (car VAL)) 1)
       (<= 1 (atoi (cadr VAL)) 26)
       )
  )


(defun CHECK_AREA (MENU / MENU_NAME MENU_AREA FLAG)
  (setq ERROR_ST "\Error in CHECK_AREA: ")  
  (foreach MENU_NAME '("TABLET1" "TABLET2" "TABLET3" "TABLET4" "SCREEN")
    (if (and (/= MENU_NAME (car MENU)) (setq MENU_AREA (assoc MENU_NAME MENU_LIST)))
      (if (or
	    (and
	      (<= (nth 2 MENU_AREA) (nth 2 MENU) (nth 4 MENU_AREA));Upper left X
  	       (<= (nth 3 MENU_AREA) (nth 3 MENU) (nth 5 MENU_AREA));Upper left Y
	      )
	    (and
	       (<= (nth 2 MENU_AREA) (nth 4 MENU) (nth 4 MENU_AREA));Lower right X
  	       (<= (nth 3 MENU_AREA) (nth 5 MENU) (nth 5 MENU_AREA));Lower right Y
	      )
	    )
	(setq FLAG T)
	)
      )
    )
  FLAG
  )

    
;SETS THE FIELDS    
(defun SHOW_VAL (/ MENU_NAME MENU_AREA)
  (setq ERROR_ST "\Error in SHOW_VAL: ")
  (foreach MENU_NAME '("Tablet1" "Tablet2" "Tablet3" "Tablet4" "Screen")
    (if (setq MENU_AREA (assoc (strcase MENU_NAME) MENU_LIST))
      (progn
	(if (last MENU_AREA);enable edit boxes
	  (progn
	    (mode_tile (strcat MENU_NAME "_ul") 0)
	    (mode_tile (strcat MENU_NAME "_lr") 0)
	    (set_tile (strcat "Import" (substr MENU_NAME 7)) "1")
	    )
	  (progn;disable edit boxes
	    (mode_tile (strcat MENU_NAME "_ul") 1)
	    (mode_tile (strcat MENU_NAME "_lr") 1)
	    (set_tile (strcat "Import" (substr MENU_NAME 7)) "0")
	    )
	  )
	(set_tile (strcat "COUNT" (substr MENU_NAME 7) "") (itoa (nth 1 MENU_AREA)))
	(set_tile (strcat MENU_NAME "_ul") 
          (if (/= (nth 2 MENU_AREA) (nth 3 MENU_AREA))
            (strcat (nth 2 MENU_AREA) ":" (nth 3 MENU_AREA))
            ""
            )
	  )
	(set_tile (strcat MENU_NAME "_lr")
          (if (/= (nth 4 MENU_AREA) (nth 5 MENU_AREA))
            (strcat (nth 4 MENU_AREA) ":" (nth 5 MENU_AREA))
            ""
            )
	  )
	)
      (progn;if menu area doesn't exist disable edit boxes
	(set_tile (strcat MENU_NAME "_ul") "")
	(set_tile (strcat MENU_NAME "_lr") "")
	(set_tile (strcat "Import" (substr MENU_NAME 7)) "0")
	(mode_tile (strcat MENU_NAME "_ul") 1)
	(mode_tile (strcat MENU_NAME "_lr") 1)
	)
      )
    )
  )

(defun SET_EDIT (/ MENU)
  (setq ERROR_ST "\Error in SET_EDIT: ")  
  (get_tile "menulist")
  (setq MENU (nth (atoi (get_tile "menulist")) MENU_LIST))
  (mapcar 'set_tile '("menu" "cells" "llrow" "llcol" "urrow" "urcol") menu)
  )

(defun show_layout (/ MENU DIMX DIMY COUNT CELLX CELLY UL_X UL_Y LR_X LR_Y MENU)
  (setq ERROR_ST "\Error in TAB_IMP_CALLBK: ")  
  (setq DIMX (dimx_tile "layout") DIMY (dimy_tile "layout"))
  (start_image "layout")
  (fill_image 0 0 DIMX DIMY 0)
  (setq COUNT 0)
  (SETQ CELLX (/ DIMX 26.0) CELLY (/ DIMY 26.0));width and height of each cell as REAL to keep it accurate
  (repeat 27
    (vector_image 0 (fix (* COUNT CELLY)) DIMX (fix (* COUNT CELLY)) 8);Horizontal
    (vector_image (fix (* COUNT CELLX)) 0 (fix (* COUNT CELLX)) DIMY 8);Vertical
    (setq COUNT (1+ COUNT))
    )
  (foreach MENU MENU_LIST
    (if (not (member "" MENU))
      (progn
        (setq
          UL_X (fix (- (* CELLX (atoi (nth 3 MENU))) (* 0.5 CELLX)));Range 1-26	  
	  UL_Y (fix (+ (* CELLY (- (ascii (nth 2 MENU)) 65)) (* 0.5 CELLY)));Range A-Z
          LR_X (fix (- (* CELLX (atoi (nth 5 MENU))) (* 0.5 CELLX)));Range 1-26	  
          LR_Y (fix (+ (* CELLY (- (ascii (nth 4 MENU)) 65)) (* 0.5 CELLY)));Range A-Z	  
	  )
        (vector_image UL_X UL_Y LR_X UL_Y 2)
        (vector_image LR_X UL_Y LR_X LR_Y 2)
        (vector_image LR_X LR_Y UL_X LR_Y 2)
        (vector_image UL_X LR_Y UL_X UL_Y 2)
	)
      )
    )
  (end_image)
  )

(defun PARSE (STR DELIM / COUNT CH RES_STR RES_LIST)
  (setq ERROR_ST "\Error in PARSE: ")  
  (if (= (type STR) 'STR)
    (progn
      (setq COUNT 1 RES_STR "" RES_LIST (list))
      (repeat (strlen STR)
        (setq CH (substr STR COUNT 1))
	(if (= CH DELIM)
	  (setq RES_LIST (append RES_LIST (list RES_STR)) RES_STR "")
	  (setq RES_STR (strcat RES_STR CH))
          )
	(setq COUNT (1+ COUNT))
	)
      (if (> (strlen RES_STR) 0)
	(setq RES_LIST (append RES_LIST (list RES_STR)))
	)
      RES_LIST
      )
    )
  )
   
;This function will read an AutoCAD style menu and output an IntelliCAD Style menu
;Reads just button and tablet areas, ignores everything else
(defun READ_MENU (FILENAME / READF WRITEF LOGFILE RECORD MENU_AREA MENU_LINE)
  (setq ERROR_ST "\Error in READ_MENU: ")  
  (setq MAX_MENU_STR 255 MENU_LIST '(("SCREEN" 1 "J" "12" "R" "22" T)))
  (if (findfile (strcat FILENAME ".mnu"))
    (progn
      (setq READF (open (strcat FILENAME ".mnu") "r"))
      (setq WRITEF (open (strcat FILENAME ".mni") "w"))
      (setq LOGFILE (open (strcat FILENAME ".mlg") "w"))
      (while (setq RECORD (read-line READF))
	(cond
	  ((= (substr RECORD 1 3) "***");new menu area
	    (if (member (substr RECORD 4 6) '("TABLET" "BUTTON"))
	      (progn
	        (setq MENU_AREA (substr RECORD 4) MENU_LINE nil MENU_COUNT 1)
  	        (if (= MENU_AREA "TABLET1")
		    (setq MENU_LIST (cons (list MENU_AREA MENU_COUNT "A" "1" "I" "25" T) MENU_LIST));set default area for Tablet 1
		    (setq MENU_LIST (cons (list MENU_AREA MENU_COUNT "" "" "" "" nil) MENU_LIST))
		    )
		  (write-line RECORD WRITEF)
		  )
	      (setq MENU_AREA nil)
	      )
	    )
	  ((zerop (strlen RECORD)));empty string, do nothing
	  ((= (substr RECORD 1 2) "//"));comment, do nothing
 	  ((= (substr RECORD 1 2) "**"));sub menu area, ignore
	  ((= (substr RECORD (strlen RECORD) 1) "+")
	    (setq MENU_LINE (strcat (cond (MENU_LINE) (T "")) RECORD))
	    )
	  (MENU_AREA
	    (if (null MENU_LINE) (setq MENU_LINE RECORD))
	    (if (> (strlen MENU_LINE) MAX_MENU_STR)
	      (write-line (strcat "Menu: " MENU_AREA " Cell: " (itoa MENU_COUNT) " Truncated") LOGFILE)
	      )
	    (write-line (substr MENU_LINE 1 MAX_MENU_STR) WRITEF)
	    (setq MENU_COUNT (1+ MENU_COUNT) MENU_LINE nil)
	    )
	  )
	)
      (close READF)
      (close WRITEF)
      (close LOGFILE)
      (set_tile "status" (strcat "Log file written to: " FILENAME ".mlg"))
      )
    (princ (strcat "\nFile " FILENAME " not found!"))
    )
  )

(defun IMPORT_MENU (FILENAME MENU_LIST / READF LOGFILE RECORD MENU_AREA MENU)
  (setq ERROR_ST "\Error in IMPORT_MENU: ")
  (if (findfile (strcat FILENAME ".mni"))
    (progn
      (setq READF (open (strcat FILENAME ".mni") "r"))
      (setq LOGFILE (open (strcat FILENAME ".mlg") "a"))
      (while (setq RECORD (read-line READF))
	(cond
	  ((= (substr RECORD 1 3) "***");new menu area
	    (setq MENU_AREA (substr RECORD 4 7)
	          MENU (assoc MENU_AREA MENU_LIST)
		  )
	    (if (and
		  (last MENU);menu is tagged for import
		  (not (member "" MENU))
		  )
	      (progn
	      (setq MENU_ROWS (1+ (- (ascii (nth 4 MENU)) (ascii (nth 2 MENU))))
		    MENU_COLS (1+ (- (atoi (nth 5 MENU)) (atoi (nth 3 MENU))))
		    MENU_MAXLEN (* MENU_ROWS MENU_COLS)
		    MENU_COUNT 0
		    )
	      )
	      (setq MENU nil MENU_AREA nil MENU_MAXLEN nil)
	      )
	    )
	  (MENU_AREA
	    (setq MENU_COUNT (1+ MENU_COUNT))
	    (cond
	      ((= (substr MENU_AREA 1 6) "BUTTON")
	        (tablet_setbutton MENU_COUNT RECORD);This needs work
	        )
	      ((= (substr MENU_AREA 1 6) "TABLET")
	        (if (<= MENU_COUNT MENU_MAXLEN)
		  (progn
	            (setq ROW (1+ (fix (/ (1- MENU_COUNT) MENU_COLS)))
			  COL (- MENU_COUNT (* (1- ROW) MENU_COLS))
			  )
		    (setq RECORD (last (parse RECORD "]")));remove label
	            (tablet_setgriditem (+ ROW (- (ascii (nth 2 MENU)) 65)) (+ COL -1 (atoi (nth 3 MENU))) RECORD)
		    )
		  (write-line (strcat "Menu: " MENU_AREA " Cell: " (itoa MENU_COUNT) " Not imported") LOGFILE)
		  )
	        )
	      )
	    )
	  )
	)
      (close READF)
      (close LOGFILE)
      (princ (strcat "\nLog file written to: " FILENAME ".mlg"))
      )
    )
  )


(defun READ_INI (/ FILENAME READF RECORD)
  (setq ERROR_ST "\Error in READ_INI: ")  
  (if (setq FILENAME (findfile "tablet_import.ini"))
    (progn
      (setq READF (open FILENAME "r"))
      (setq RECORD (read (read-line READF)))
      (close READF)
      )
    )
  (if (and RECORD (= (type RECORD) 'LIST))
    (progn (setq MENU_FILE (car RECORD)) (cdr RECORD))
    '(("SCREEN" 1 "J" "12" "R" "22" T))
    )
  )

(defun SAVE_INI (/ FILENAME READF)
  (setq ERROR_ST "\Error in SAVE_INI: ")  
  (cond
    ((setq FILENAME (findfile "tablet_import.ini")))
    ((setq FILENAME (findfile "tablet_import.lsp"))
      (setq FILENAME (strcat (car (parse FILENAME ".")) ".ini"))
      )
    ((setq FILENAME (findfile "icad.exe"))
      (setq FILENAME (strcat (apply 'strcat (mapcar '(lambda (STR) (strcat STR "\\")) (reverse (cdr (reverse (parse FILENAME "\\")))))) "tablet_import.ini"))
      )
    )
  (setq READF (open FILENAME "w"))
  (prin1 (cons MENU_FILE MENU_LIST) READF)
  (close READF)
  )

;The following function will clear all tablet cells setting them to ""
(defun C:CLEARTAB (/ COL ROW)
(setq COL 1 ROW 1)
(repeat 26
  (repeat 26
    (tablet_setgriditem ROW COL (strcat ""))
    (setq COL (1+ COL))
    )
  (setq ROW (1+ ROW) COL 1)
  )
)

(defun C:TABI () (C:TABLET_IMPORT))

; tablet_modify.lsp
; Copyright (C) 1998 Visio Corporation.  All Rights Reserved.

; By Ronald Prepchuk

(defun C:TABLET_MODIFY (/ DCL_ID CELL DIMX DIMY COUNT CELLX CELLY *ERROR* ERROR_ST)
  (defun *ERROR* (STR)
    (princ ERROR_ST)
    (princ STR)
    (princ "\nAvailable commands are: TABLET_MODIFY or TABM")
    (princ)
  )
  (setq ERROR_ST "\nError in C:TABLET_MODIFY ")
  (cond
    ((not tablet_getgriditem);not IntelliCAD 98d
     (alert "You are not using IntelliCAD 98d.  This program\nwill only work with release 98d or later.")
     (exit)
    )
    ((and tablet_getgriditem (= (type (tablet_getgriditem 1 1)) 'INT));IntelliCAD 98d but digitizer not configured properly
     (alert "Your digitizer tablet has not been properly configured.\nPlease refer to the documentation for proper setup procedures.")
     (exit)
    )
    ((and tablet_getgriditem (= (type (tablet_getgriditem 1 1)) 'STR));IntelliCAD 98d and digitizer configured properly
     (if (= (setq DCL_ID (load_dialog "tablet.dcl")) -1)
       (progn (setq ERROR_ST "\ntablet.dcl Not Found!") (exit))
       (progn
	 (new_dialog "modify_tablet" DCL_ID)
	 (mapcar
	   '(lambda (KEY)
	      (action_tile KEY "(TAB_MOD_CALLBK $KEY $REASON $X $Y)")
	    )
	   '("layout" "accept" "help")
	 )
	 (setq CELL (list 1 1 (tablet_getgriditem 1 1)))
	 (set_cells 1 1 nil)
	 (show_grid)
	 (mode_tile "accept" 2) ;set focus to tile
	 (start_dialog)
	 (unload_dialog DCL_ID)
       )
     )
    )
  )
  (princ)
)


(defun TAB_MOD_CALLBK ($KEY $REASON $X $Y / ROW COL)
  (setq ERROR_ST "\nError in TAB_MOD_CALLBK: ")
  (cond
    ((= $KEY "layout")
      (setq ROW (1+ (fix (/ $Y CELLY))) COL (1+ (fix (/ $X CELLX))))
      (set_cells ROW COL T)     
     )
    ((= $KEY "accept")
      (set_cells (nth 0 CELL) (nth 1 CELL) T)
      (done_dialog)
      )
    ((= $KEY "help")
     (alert "To change the command associated with a cell, click on that cell within the grid.\nThe contents of that cell will show up in the box labeled 'Cell contents'.   \nYou may edit the contents and when you switch focus to a different \nbutton or select 'Done' the changes you have made will be saved.  \nIMPORTANT: there is no Undo button, once you make changes they are \nsaved.")
     )    
    )
  )

(defun SET_CELLS (ROW COL FLAG)
  (setq ERROR_ST "\Error in SET_CELLS: ")
  (set_tile "cell_num" (strcat "Cell: " (chr (+ 64 ROW)) ":" (itoa COL)))
  (if FLAG;user switched focus
    (if (/= (get_tile "cell") (last CELL));cell has been modified
      (tablet_setgriditem (nth 0 CELL) (nth 1 CELL) (get_tile "cell"))
      )
    (set_tile "cell" (tablet_getgriditem ROW COL))
    )
  (setq CELL (list ROW COL (tablet_getgriditem ROW COL)))
  (set_tile "cell" (last CELL))
  )

(defun SHOW_GRID (/ COUNT)
  (setq ERROR_ST "\Error in SHOW_GRID: ")
  (setq DIMX (dimx_tile "layout") DIMY (dimy_tile "layout"))
  (start_image "layout")
  (fill_image 0 0 DIMX DIMY 0)
  (setq COUNT 0)
  (SETQ CELLX (/ DIMX 26.0) CELLY (/ DIMY 26.0));width and height of each cell as REAL to keep it accurate
  (repeat 27
    (vector_image 0 (fix (* COUNT CELLY)) DIMX (fix (* COUNT CELLY)) 8);Horizontal
    (vector_image (fix (* COUNT CELLX)) 0 (fix (* COUNT CELLX)) DIMY 8);Vertical
    (setq COUNT (1+ COUNT))
    )
  (end_image)
  )

(defun C:TABM () (C:TABLET_MODIFY))

; button_modify.lsp
; Copyright (C) 1998 Visio Corporation.  All Rights Reserved.

; By Ronald Prepchuk

(defun C:BUTTON_MODIFY (/ DCL_ID BUTTON *ERROR* ERROR_ST)
  (defun *ERROR* (STR)
    (princ ERROR_ST)
    (princ STR)
    (princ "\nAvailable commands are: BUTTON_MODIFY or BUTM")
    (princ)
  )
  (setq ERROR_ST "\nError in C:BUTTON_MODIFY: ")
  (cond
    ((not tablet_getbutton);not IntelliCAD 98d
     (alert "You are not using IntelliCAD 98d.  This program\nwill only work with release 98d or later.")
     (exit)
    )
    ((and tablet_getbutton (= (type (tablet_getbutton 0)) 'INT));IntelliCAD 98d but digitizer not configured properly
     (alert "Your digitizer tablet has not been properly configured.\nPlease refer to the documentation for proper setup procedures.")
     (exit)
    )
    ((and tablet_getbutton (= (type (tablet_getbutton 0)) 'STR));IntelliCAD 98d and digitizer configured properly
     (if (= (setq DCL_ID (load_dialog "tablet.dcl")) -1)
       (progn (setq ERROR_ST "\ntablet.dcl Not Found!") (exit))
       (progn
	 (new_dialog "modify_button" DCL_ID)
	 (mapcar '(lambda (KEY)
		    (action_tile KEY "(BUT_MOD_CALLBK $KEY $REASON)")
		  )
		 '("picks"	  "pick_st"	 "pick_sh"
		   "pick_co"	  "pick_cs"	 "pbutton1"
		   "pbutton2"	  "pbutton3"	 "pbutton4"
		   "pbutton5"	  "pbutton6"	 "pbutton7"
		   "pbutton8"	  "pbutton9"	 "pbutton10"
		   "pbutton11"	  "pbutton12"	 "pbutton13"
		   "pbutton14"	  "pbutton15"	 "pbutton16"
		   "button_num"	  "button"	 "accept"
		   "help"
		  )
	 )
	 (setq BUTTON (list 0 1 (tablet_getbutton 0))) ;default value
	 (set_buttons 0 1 nil)
	 (start_dialog)
	 (unload_dialog DCL_ID)
       )
     )
    )
  )
  (princ)
)


(defun BUT_MOD_CALLBK ($KEY $REASON)
  (setq ERROR_ST "\nError in BUT_MOD_CALLBK: ")
  (cond
    ((= (substr $KEY 1 4) "pick")
      (set_buttons (cadr (assoc (get_tile "picks") '(("pick_st" 0) ("pick_sh" 16) ("pick_co" 32) ("pick_cs" 48)))) (nth 1 BUTTON) T)
      )
    ((= (substr $KEY 1 7) "pbutton")
      (set_buttons (nth 0 BUTTON) (atoi (substr $KEY 8)) T)     
      )
    ((= $KEY "accept")
      (set_buttons (nth 0 BUTTON) (nth 1 BUTTON) T)     
      (done_dialog)
      )
    ((= $KEY "help")
      (alert "IntelliCAD supports digitizer pucks with up to 16 buttons which may be used \nwith key combinations to provide up to 64 virtual buttons.  These buttons \nare laid out differently on different devices and yours may not match the \nformat shown here.  You may assign command strings to any of these \nbuttons, however  the two designated as Left-Click and Right-Click will \nmaintain their functions.\n\nTo change the command associated with a button, click on that buttons \nnumber.   The contents of that button will show up in the box labeled 'Cell \ncontents'.   You may edit the contents and when you switch focus to a \ndifferent button or select 'Done' the changes you have made will be saved.  \nIMPORTANT: there is no Undo button, so once you make changes they are \nsaved.")
      )    
    )
  )

(defun SET_BUTTONS (PICK BUTTON_NUM FLAG)
  (setq ERROR_ST "\nError in SET_BUTTONS: ")  
  (set_tile "button_num" (strcat "Button: " (itoa BUTTON_NUM)))
  (if FLAG;user switched focus
    (if (/= (get_tile "button") (last BUTTON));cell has been modified
      (tablet_setbutton (+ -1 (nth 0 BUTTON) (nth 1 BUTTON)) (get_tile "button"))
      )
    (set_tile "button" (tablet_getbutton (+ -1 PICK BUTTON_NUM)))
    )
  (setq BUTTON (list PICK BUTTON_NUM (tablet_getbutton (+ -1 PICK BUTTON_NUM))))
  (set_tile "button" (last BUTTON))
  )

(defun C:BUTM () (C:BUTTON_MODIFY))

 ; tablet_export.lsp
 ; Copyright (C) 1998 Visio Corporation.  All Rights Reserved.

 ; By Ronald Prepchuk

 ;This command will export the current settings of the tablet and button menus to a .lsp file
 ;that can be loaded on a different computer to give it the same menu functionality

(defun C:TABLET_EXPORT ()
  (defun *ERROR* (STR)
    (princ ERROR_ST)
    (princ STR)
    (princ "\nAvailable commands are: TABLET_EXPORT or TABE")
    (princ)
  )
  (setq ERROR_ST "\nError in C:TABLET_EXPORT:")
  (setq WRITEF (open "TABLET_SETTINGS.LSP" "w"))
  (setq	COL 1 ROW 1)
  (princ ";Load this file in IntelliCAD 98d or later to set tablet and button menus." WRITEF)
  (repeat 26
    (repeat 26
      (setq CELL (tablet_getgriditem ROW COL))
      (print (list 'tablet_setgriditem ROW COL CELL) WRITEF)
      (setq COL (1+ COL))
    )
    (setq ROW (1+ ROW) COL 1)
  )
  (setq BUTTON_NUM 0)  
  (repeat 64
    (setq CELL (tablet_getbutton BUTTON_NUM))
    (print (list 'tablet_setbutton BUTTON_NUM CELL) WRITEF)
    (setq BUTTON_NUM (1+ BUTTON_NUM))
  )
  (close WRITEF)
  (princ (strcat "\nFile written to " (findfile "TABLET_SETTINGS.LSP")))
  (princ)
)

(defun C:TABE () (C:TABLET_EXPORT))

(princ "\nAvailable commands are: BUTTON_MODIFY or BUTM")
(princ)

(princ "\nAvailable commands are: TABLET_MODIFY or TABM")
(princ)

(princ "\nAvailable commands are: TABLET_IMPORT or TABI, CLEARTAB")
(princ)

(princ "\nAvailable commands are: TABLET_EXPORT or TABE")
(princ)
